const express = require('express');
const crypto = require('crypto');
const app = express();
const port = 3000;

// Middleware برای پردازش درخواست‌ها با فرمت JSON
app.use(express.json());

const { generatePrivateKey , keyToBase64 , generatePublicKey } = require('./wireguard.js');


// راه‌اندازی یک مسیر API ساده
app.get('/api/wireguard/key_generate', (req, res) => {


    let presharedKey = crypto.randomBytes(32);


    let private_key = generatePrivateKey(presharedKey);
    let public_key = generatePublicKey(private_key);
    let private_key_base64 = keyToBase64(private_key);
    let public_key_base64 = keyToBase64(public_key);

    const message = { private_key: private_key_base64 , public_key : public_key_base64 };
    res.json(message);
});


// شنیدن درخواست‌ها به پورت مشخص شده
app.listen(port, () => {
    console.log(`Server is running on port ${port}`);
});