<?php

enum methods
{
    case sendMessage;
    case sendPhoto;
    case deleteMessage;
    case getChatMember;
    case getChat;
    case editMessageText;
    case editMessageCaption;
    case sendAudio;
    case sendDocument;
    case sendVideo;
    case sendVoice;
    case sendVideoNote;
    case answerCallbackQuery;
    case answerInlineQuery;
    case editMessageReplyMarkup;
}

enum data
{
    case chat_id;
    case text;
    case reply_markup;
    case message_id;
    case reply_to_message_id;
    case photo;
    case audio;
    case document;
    case video;
    case voice;
    case video_note;
    case caption;
    case parse_mode;
    case Markdown;
    case MarkdownV2;
    case HTML;
    case callback_query_id;
    case show_alert;
    case inline_query_id;
    case protect_content;
    case results;
    case remove_keyboard;
    case disable_web_page_preview;
}

enum results
{
    case type;
    case id;
    case title;
    case description;
    case reply_markup;
    case thumb_url; // for icon
    case thumbnail_url;
    case input_message_content;
}


function bt($method, $datas = [], $user_id = 0, $TokenNow = 0)
{
    if ($TokenNow == 0) {
        if ($user_id == 0) {
            $token = 0;
        } else {
        }
    } else {
        $token = $TokenNow;
    }

    $url = 'https://api.telegram.org/bot' . token . '/' . $method;
    if ($token != 0)
        $url = 'https://api.telegram.org/bot' . $token . '/' . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}

function send_developer($text)
{
    bt(methods::sendMessage->name, [data::chat_id->name => "1246009365", data::text->name => $text]);
}

function send($text, $from_id)
{
    if ($from_id != 0)
        bt(methods::sendMessage->name, [data::chat_id->name => $from_id, data::text->name => $text]);
}