<?php

unlink("error_log");

// mikrotik
require "LblMikrotik.php";
require_once "../config/server.php";
include_once "../DateTime/DateTime.php";
$API = new Routerosapi();
// v2ray
$ssl = false;
global $baseUrl;
// v2ray Sanaei
require('Sanaei.php');
$Sanaei = new Sanaei($baseUrl);
// v2ray marzban
require('Marzban.php');
$marzban = new Marzban($baseUrl);
// database
global $connect;


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["request"])) {
        $request = $_POST["request"];
        if ($request == "get_volom") {
            $peer_id = $_POST["peer_id"];
            $res = Bytes_to_MB(getVolome($peer_id));
            echo "get_volom:" . $res;
            exit();
        } elseif ($request == "resetDate_config") {
            $peer_id = $_POST["peer_id"];
            $days = 0;
            if (isset($_POST['days'])) {
                $days = $_POST['days'];
                if (!is_numeric($days)) {
                    echo "تعداد روز مورد نظر را برای ویرایش تاریخ به صورت عدد وارد نمایید .";
                    exit();
                }
            }
            $peer_data = getPeerById($peer_id);
            $panel_id = $peer_data['panel_id'];
            $protocol = $peer_data['typeconfig'];
            $wire_id = $peer_data["wire_id"];
            $expire_date = $peer_data["expire_date"];
            $status = $peer_data["status"];
            if ($days != 0 && $status != 0) {
                echo "not expired";
                exit();
            }
            if ($protocol == "wireguard") {
                $interface = $peer_data['name'];
                $address = $peer_data["address"];
                if ($wire_id == 0) {
                    if (connectMikrotik($panel_id)) {
                        $API->write("/interface/wireguard/peers/print", false);
                        $API->write("?allowed-address=" . $address);
                        $res = $API->read();
                        if (count($res) > 0) {
                            $wire_id = $res[0]['.id'];
                            if ($wire_id != 0 && $wire_id != "") {
                                if (SetWireIdById($peer_id, $wire_id) == 0) {
                                    echo "updateed peer in database for set .id";
                                    exit();
                                }
                            } else {
                                echo ".id back : null or 0";
                                exit();
                            }
                        } else {
                            echo "not found peer";
                            exit();
                        }
                    } else {
                        echo "not connect server";
                        exit();
                    }
                }
                if (wire_setstatus($panel_id, $wire_id, true) == "ok") {
                    global $connect;
                    if ($days == 0) {
                        $connect->query("UPDATE `peers` SET `expire_date`='0',`status`='0' WHERE `id` = '$peer_id'");
                        echo "reset_date";
                    } else if ($days != 0 && is_numeric($days)) {
                        $expire_date = DateFormat(DateSumDay($expire_date, $days));
                        $connect->query("UPDATE `peers` SET `expire_day`=`expire_day`+'$days',`expire_date`='$expire_date' WHERE `id` = '$peer_id'");
                        echo "edit_date";
                    }
                    exit();
                }
            } else if ($protocol == "ppp") {
                $Username = $peer_data['name'];
                $Password = $peer_data["pass"];
                if ($wire_id == 0) {
                    $API->write("/user-manager/user/print", false);
                    $API->write("?name=$Username");
                    $res = $API->read();
                    $wire_id = $res[0]['.id'];
                    if (SetWireIdById($peer_id, $wire_id) == 0) {
                        echo "updated peer in database for set .id";
                        exit();
                    }
                }
                if (ppp_setstatus($panel_id, $wire_id, true) == "ok") {
                    global $connect;
                    if ($days == 0) {
                        $connect->query("UPDATE `peers` SET `expire_date`='0',`status`='0' WHERE `id` = '$peer_id'");
                        echo "reset_date";
                    } else if ($days != 0 && is_numeric($days)) {
                        $expire_date = DateFormat(DateSumDay($expire_date, $days));
                        $connect->query("UPDATE `peers` SET `expire_day`=`expire_day`+'$days',`expire_date`='$expire_date' WHERE `id` = '$peer_id'");
                        echo "edit_date";
                    }
                }
            } else if ($protocol == "v2ray") {
                if (v2ray_setstatus($peer_id, true) == "ok") {
                    global $connect;
                    if ($days == 0) {
                        $connect->query("UPDATE `peers` SET `expire_date`='0',`status`='0' WHERE `id` = '$peer_id'");
                        echo "reset_date";
                    } else if ($days != 0 && is_numeric($days)) {
                        $expire_date = DateFormat(DateSumDay($expire_date, $days));
                        $connect->query("UPDATE `peers` SET `expire_day`=`expire_day`+'$days',`expire_date`='$expire_date' WHERE `id` = '$peer_id'");
                        echo "edit_date";
                    }
                }
            }
        } elseif ($request == "resetVolome_config") {
            $peer_id = $_POST["peer_id"];
            $peer_data = getPeerById($peer_id);
            $panel_id = $peer_data['panel_id'];
            $protocol = $peer_data['typeconfig'];
            $wire_id = $peer_data["wire_id"];
            $user_id = $peer_data["user_id"];
            $volome_user = getUserVolome($user_id);
            if ($volome_user != 0) {
                $volome_peer = GetVolomePeerById($peer_id);
                $volome_now = getUserVolome_use($user_id);
                $volome_now = $volome_now + $volome_peer;
                if ($volome_now > $volome_user) {
                    echo "MaxVolome";
                    exit();
                }
                if ($volome_user != 0) {
                    $volome_now_peer = getVolome($peer_id);
                    if (alter_UserVolomeUse($user_id, $volome_now_peer) == false) {
                        echo "error : ResetVolome";
                        exit();
                    }
                }
            }
            if ($protocol == "wireguard") {
                $address = $peer_data["address"];
                if ($wire_id == 0) {
                    if (connectMikrotik($panel_id)) {
                        $API->write("/interface/wireguard/peers/print", false);
                        $API->write("?allowed-address=" . $address);
                        $res = $API->read();
                        if (count($res) > 0) {
                            $wire_id = $res[0]['.id'];
                            if ($wire_id != 0 && $wire_id != "") {
                                if (SetWireIdById($peer_id, $wire_id) == 0) {
                                    echo "updateed peer in database for set .id";
                                    exit();
                                }
                            } else {
                                echo ".id back : null or 0";
                                exit();
                            }
                        } else {
                            echo "not found peer";
                            exit();
                        }
                    } else {
                        echo "not connect server";
                        exit();
                    }
                }
                if (wire_resetvolom($panel_id, $address) == "ok") {
                    global $connect;
                    $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                    echo "reset_volome";
                    exit();
                }
            } else if ($protocol == "ppp") {
                $Username = $peer_data['name'];
                $Password = $peer_data["pass"];
                if ($wire_id == 0) {
                    $API->write("/user-manager/user/print", false);
                    $API->write("?name=$Username");
                    $res = $API->read();
                    $wire_id = $res[0]['.id'];
                }
                if (ppp_resetvolom($panel_id, $wire_id, $Username, $Password) == "ok") {
                    $API->write("/user-manager/user/print", false);
                    $API->write("?name=$Username");
                    $res = $API->read();
                    $wire_id = $res[0]['.id'];
                    SetWireIdById($peer_id, $wire_id);
                    global $connect;
                    $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                    echo "reset_volome";
                    exit();
                }
            } else if ($protocol == "v2ray") {
                if (v2ray_resetvolom($peer_id) == "ok") {
                    global $connect;
                    $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                    echo "reset_volome";
                    exit();
                }
            }
        } elseif ($request == "disableConfig") {
            $peer_id = $_POST["peer_id"];
            $peer_data = getPeerById($peer_id);
            $panel_id = $peer_data['panel_id'];
            $protocol = $peer_data['typeconfig'];
            $wire_id = $peer_data['wire_id'];
            $user_id = $peer_data['user_id'];
            $status_peer = $peer_data['status'];
            $volome_user = getUserVolome($user_id);
            if ($volome_user != 0) {
                $volome_peer = GetVolomePeerById($peer_id);
                $volome_now = getUserVolome_use($user_id);
                $volome_now = $volome_now + $volome_peer;
                if ($status_peer == 3) {
                    if ($volome_now > $volome_user) {
                        echo "MaxVolome";
                        exit();
                    }
                    if (alter_UserVolomeUse($user_id, $volome_peer) == false) {
                        echo "error : ResetVolome";
                        exit();
                    }
                } else if ($status_peer == 0) {
                    $volome_now_peer = getVolome($peer_id);
                    if ($volome_now_peer > 104857600) {
                        echo "error : این کاربر بیشتر از 100 مگابایت استفاده کرده است. قابل غیرفعال سازی نیست";
                        exit();
                    }
                    $volome_peer *= -1;
                    if (alter_UserVolomeUse($user_id, $volome_peer) == false) {
                        echo "error : ResetVolome";
                        exit();
                    }
                }
            }
            if ($protocol == "wireguard") {
                $address = $peer_data["address"];
                if ($wire_id == 0) {
                    if (connectMikrotik($panel_id)) {
                        $API->write("/interface/wireguard/peers/print", false);
                        $API->write("?allowed-address=" . $address);
                        $res = $API->read();
                        if (count($res) > 0) {
                            $wire_id = $res[0]['.id'];
                            if ($wire_id != 0 && $wire_id != "") {
                                if (SetWireIdById($peer_id, $wire_id) == 0) {
                                    echo "updateed peer in database for set .id";
                                    exit();
                                }
                            } else {
                                echo ".id back : null or 0";
                                exit();
                            }
                        } else {
                            echo "not found peer";
                            exit();
                        }
                    } else {
                        echo "not connect server";
                        exit();
                    }
                }
                if ($status_peer == 0) {
                    if (wire_setstatus($panel_id, $wire_id, false) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='3' WHERE `id` = '$peer_id'");
                        echo "disable_config";
                        exit();
                    }
                } else if ($status_peer == 3) {
                    if (wire_setstatus($panel_id, $wire_id, true) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                        echo "enable_config";
                        exit();
                    }
                }
            } else if ($protocol == "ppp") {
                $Username = $peer_data['name'];
                $Password = $peer_data["pass"];
                if ($wire_id == 0) {
                    if (connectMikrotik($panel_id)) {
                        $API->write("/user-manager/user/print", false);
                        $API->write("?name=$Username");
                        $res = $API->read();
                        $wire_id = $res[0]['.id'];
                        if (SetWireIdById($peer_id, $wire_id) == 0) {
                            echo "updateed peer in database for set .id";
                            exit();
                        }
                    }
                }
                if ($status_peer == 0) {
                    if (ppp_setstatus($panel_id, $wire_id, false) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='3' WHERE `id` = '$peer_id'");
                        echo "disable_config";
                        exit();
                    }
                } else if ($status_peer == 3) {
                    if (ppp_setstatus($panel_id, $wire_id, true) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                        echo "enable_config";
                        exit();
                    }
                }
            } else if ($protocol == "v2ray") {
                if ($status_peer == 0) {
                    if (v2ray_setstatus($peer_id, false) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='3' WHERE `id` = '$peer_id'");
                        echo "disable_config";
                        exit();
                    }
                } else if ($status_peer == 3) {
                    if (v2ray_setstatus($peer_id, true) == "ok") {
                        global $connect;
                        $connect->query("UPDATE `peers` SET `status`='0' WHERE `id` = '$peer_id'");
                        echo "enable_config";
                        exit();
                    }
                }
            }
            return 0;
            exit();
        } elseif ($request == "DeleteConfig") {
            $peer_id = $_POST["peer_id"];
            $peer_data = getPeerById($peer_id);
            $panel_id = $peer_data['panel_id'];
            $protocol = $peer_data['typeconfig'];
            $wire_id = $peer_data['wire_id'];
            if ($protocol == "ppp") {
                if ($wire_id == 0) {
                    $Username = $peer_data['name'];
                    if (connectMikrotik($panel_id)) {
                        $API->write("/user-manager/user/print", false);
                        $API->write("?name=$Username");
                        $res = $API->read();
                        $wire_id = $res[0]['.id'];
                        if (SetWireIdById($peer_id, $wire_id) == 0) {
                            echo "updateed peer in database for set .id";
                            exit();
                        }
                    }
                }
                if (ppp_Delete($panel_id, $wire_id) == "ok") {
                    $connect->query("delete from `peers` WHERE `id` = '$peer_id'");
                    echo "ConfigDeleted";
                    exit();
                }
            } elseif ($protocol == "wireguard") {
                $address = $peer_data["address"];
                if ($wire_id == 0) {
                    if (connectMikrotik($panel_id)) {
                        $API->write("/interface/wireguard/peers/print", false);
                        $API->write("?allowed-address=" . $address);
                        $res = $API->read();
                        if (count($res) > 0) {
                            $wire_id = $res[0]['.id'];
                            if ($wire_id != 0 && $wire_id != "") {
                                if (SetWireIdById($peer_id, $wire_id) == 0) {
                                    echo "updateed peer in database for set .id";
                                    exit();
                                }
                            } else {
                                echo ".id back : null or 0";
                                exit();
                            }
                        } else {
                            echo "not found peer";
                            exit();
                        }
                    } else {
                        echo "not connect server";
                        exit();
                    }
                }
                if (wireguard_Delete($panel_id, $wire_id) == "ok") {
                    $connect->query("delete from `peers` WHERE `id` = '$peer_id'");
                    echo "ConfigDeleted";
                    exit();
                }
            } elseif ($protocol == "v2ray") {
                if (v2ray_Delete($peer_id) == "ok") {
                    $connect->query("delete from `peers` WHERE `id` = '$peer_id'");
                    echo "ConfigDeleted";
                    exit();
                }
            }
            echo "DeleteConfigError";
            exit();
        } elseif ($request == "find_interface_name") {
            $panel_id = $_POST["IdPanel"];
            $interface = $_POST["interface"];
            if (find_interface($panel_id, $interface, 0) == 1) {
                echo "find_interface_name";
                exit();
            }
            echo "0";
            exit();
        } elseif ($request == "find_interface_ip") {
            $panel_id = $_POST["IdPanel"];
            $address = $_POST["ip"];
            if (find_interface($panel_id, 0, $address) == 1) {
                echo "find_interface_ip";
                exit();
            }
            echo "0";
            exit();
        } elseif ($request == "CreateUser") {
            $user_id = $_POST["user_id"];
            $expire = $_POST["expire"];
            $volome = $_POST["volome"];
            $unshow_volom = $_POST["unshow_volome"];
            if (isset($_POST["auto_expire_date"]))
                $auto_expire_date = $_POST["auto_expire_date"];
            else {
                $auto_expire_date = 1;
            }
            if ($unshow_volom == "true")
                $unshow_volom = 1;
            else if ($unshow_volom == "false")
                $unshow_volom = 0;
            $volome_user = getUserVolome($user_id);
            if ($volome_user != 0) {
                if ($expire <= 0) {
                    echo "Service duration out of range";
                    exit();
                } else if ($volome <= 0) {
                    echo "Service volome out of range";
                    exit();
                }
                $volome_now = getUserVolome_use($user_id);
                $volome_now = $volome_now + ($volome * (1024 * 1024 * 1024));
                if ($volome_now > $volome_user) {
                    echo "MaxVolome";
                    exit();
                }
            }
            $protocol = $_POST["protocol"];
            if ($protocol == "wireguard") {
                $interface_id = $_POST["server_id"];
                $peer_id = CreateUserWireguard($user_id, $interface_id, $expire, $volome, $unshow_volom, $auto_expire_date);
            } else if ($protocol == "ppp") {
                $panel_id = $_POST["server_id"];
                $peer_id = CreateUserPPP($user_id, $panel_id, $expire, $volome, $unshow_volom, $auto_expire_date);
            } else if ($protocol == "v2ray") {
                $inbound_id = $_POST["server_id"];
                $peer_id = CreateUserV2ray($user_id, $inbound_id, $expire, $volome, $unshow_volom, $auto_expire_date);
            } else {
                echo "not found protocol";
                exit();
            }
            if ($peer_id != 0 && is_numeric($peer_id)) {
                echo "CreateUserSuccess:" . encode($peer_id);
                exit();
            } else {
                echo "CreateUserError:$peer_id";
                exit();
            }
            exit();
        } elseif ($request == "CheckConnect") {
            $panel_id = $_POST["panel_id"];
            echo "CheckConnect:" . CheckConnect($panel_id);
            exit();
        }
    }
} else if ($_SERVER["REQUEST_METHOD"] == "GET") {
    if (isset($_GET["request"])) {
        $request = $_GET["request"];
        if ($request == "get_volom") {
            $peer_id = $_GET["peer_id"];
            $res = Bytes_to_MB(getVolome($peer_id));
            echo $res;
            exit();
        }
    }
}


function SetMaxIp($interface_id)
{
    global $connect;
    if ($connect->query("UPDATE `interfaces` SET `max_ip` = `max_ip`+1 WHERE `Id` = '$interface_id'"))
        return 1;
    return 0;
}

function SetMaxRowPanel($panel_id)
{
    global $connect;
    if ($connect->query("UPDATE `panels` SET `row_id`= `row_id`+1 WHERE `Id` = '$panel_id'"))
        return 1;
    return 0;
}

function SetMaxRowInbound($inbound_id)
{
    global $connect;
    if ($connect->query("UPDATE `inboounds` SET `max_id`= `max_id`+1 WHERE `id` = '$inbound_id'"))
        return 1;
    return 0;
}

function SetFormatById($peer_id, $format)
{
    global $connect;
    if ($connect->query("UPDATE `peers` SET `format` = '$format' WHERE `id` = '$peer_id'"))
        return 1;
    return 0;
}

function SetWireIdById($peer_id, $Wire_id)
{
    global $connect;
    if ($connect->query("UPDATE `peers` SET `.id` = '$Wire_id' WHERE `id` = '$peer_id'"))
        return 1;
    return 0;
}

function generate_password()
{
    $NumRand = rand(124356, 986754);
    return base64_encode(substr($NumRand, 0, 3)) . substr($NumRand, 2, 3);
}

function getInterface($id)
{
    global $connect;
    $tbl = $connect->query("SELECT `panel_id`, `interface`, `ip`, `port`, `dns`,`max_ip`, `check` FROM `interfaces` WHERE `Id` = '$id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $panel_id = $dt[0][0];
        $interface = $dt[0][1];
        $ip = $dt[0][2];
        $port = $dt[0][3];
        $dns = $dt[0][4];
        $max_ip = $dt[0][5];
        return [
            'panel_id' => $panel_id,
            'interface' => $interface,
            'ip' => $ip,
            'port' => $port,
            'dns' => $dns,
            'max_ip' => $max_ip
        ];
    }
    return 0;
}


function getInbound($id)
{
    global $connect;
    $tbl = $connect->query("SELECT `panel_id`, `user_id`, `inbound_id`, `name`, `port`, `format`, `max_id` FROM `inboounds` WHERE `id` = '$id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $panel_id = $dt[0][0];
        $user_id = $dt[0][1];
        $inbound_id = $dt[0][2];
        $name = $dt[0][3];
        $port = $dt[0][4];
        $format = $dt[0][5];
        $max_id = $dt[0][6];
        return [
            'panel_id' => $panel_id,
            'user_id' => $user_id,
            'inbound_id' => $inbound_id,
            'name' => $name,
            'port' => $port,
            'format' => $format,
            'max_id' => $max_id
        ];
    }
    return 0;
}

function getPanel($id)
{
    global $connect;
    $tbl = $connect->query("SELECT `Name`, `Ip`, `Port`, `Username`, `Password`, `domain`,`mangle`,`pre_key`,`row_id`,`link_ovpn`,`format` FROM `panels` WHERE `Id` = '$id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $Name = $dt[0][0];
        $Ip = $dt[0][1];
        $Port = $dt[0][2];
        $Username = $dt[0][3];
        $Password = $dt[0][4];
        $domain = $dt[0][5];
        $mangle = $dt[0][6];
        $pre_key = $dt[0][7];
        $row_id = $dt[0][8];
        $link_ovpn = $dt[0][9];
        $format = $dt[0][10];
        return [
            'Name' => $Name,
            'Ip' => $Ip,
            'Port' => $Port,
            'Username' => $Username,
            'Password' => $Password,
            'domain' => $domain,
            'mangle' => $mangle,
            'pre_key' => $pre_key,
            'row_id' => $row_id,
            'link_ovpn' => $link_ovpn,
            'format' => $format
        ];
    }
    return 0;
}

function connectMikrotik($panel_id)
{
    global $connect;
    global $API;
    $tbl = $connect->query("SELECT `Id`, `Name`, `Ip`, `Port`, `Username`, `Password` FROM `panels` where `Id` = '$panel_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $id = $dt[0][0];
        $name = $dt[0][1];
        $ip = $dt[0][2];
        $port = $dt[0][3];
        $user = $dt[0][4];
        $pass = $dt[0][5];
        if ($API->connect($ip, $port, $user, $pass)) {
            return 1;
        }
    }
    return 0;
}


function connectV2ray_sanaei($panel_id)
{
    global $connect;
    global $Sanaei;
    global $baseUrl;
    global $ssl;
    $tbl = $connect->query("SELECT `Id`, `Name`, `Ip`, `Port`,`ssl`, `Username`, `Password` FROM `panels` where `Id` = '$panel_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $id = $dt[0][0];
        $name = $dt[0][1];
        $ip = $dt[0][2];
        $port = $dt[0][3];
        $Server_ssl = $dt[0][4];
        $user = $dt[0][5];
        $pass = $dt[0][6];
        if ($port != 0)
            $baseUrl = $ip . ':' . $port;
        else
            $baseUrl = $ip;
        $Sanaei = new Sanaei($baseUrl);
        if ($Server_ssl == 1) {
            $ssl = true;
        }
        /*if (file_exists("AutoCreate/Cookie/'.$baseUrl.'.txt'")) {
            return 1;
        }*/
        $Res = $Sanaei->login(['username' => $user, 'password' => $pass]);
        if ($Res['success'] === true || $Res['msg'] == "LoginSuccess") {
            return 1;
        }
    }
    return 0;
}


function connectV2ray_marzban($panel_id)
{
    global $connect;
    global $Marzban;
    global $baseUrl;
    global $ssl;
    $tbl = $connect->query("SELECT `Id`, `Name`, `Ip`, `Port`,`ssl`, `Username`, `Password` FROM `panels` where `Id` = '$panel_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $id = $dt[0][0];
        $name = $dt[0][1];
        $ip = $dt[0][2];
        $port = $dt[0][3];
        $Server_ssl = $dt[0][4];
        $user = $dt[0][5];
        $pass = $dt[0][6];
        if ($port != 0)
            $baseUrl = $ip . ':' . $port;
        else
            $baseUrl = $ip;
        $Marzban = new Marzban($baseUrl);
        if ($Server_ssl == 1) {
            $ssl = true;
        }
        /*if (file_exists("AutoCreate/Cookie/'.$baseUrl.'.txt'")) {
            return 1;
        }*/
        return $Marzban->login(['username' => $user, 'password' => $pass]);
    }
    return 0;
}

function GetMangle($panel_id)
{
    global $connect;
    $tbl = $connect->query("SELECT `mangle` FROM `panels` where `Id` = '$panel_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        return $dt[0][0];
    } else {
        return 0;
    }
}

function find_interface($panel_id, $interface = 0, $address_ip = 0)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        if ($interface != 0) {
            $API->write("/interface/wireguard/print", false);
            $API->write("=count-only", false);
            $API->write("?name=" . $interface);
        } else if ($address_ip != 0) {
            $API->write("/ip/address/print", false);
            $API->write("=count-only", false);
            $API->write("?network=" . $address_ip . '.0');
        }
        $res = $API->read();
        if ($res >= 1) {
            return 1;
        }
    }
    return 0;
}

function GetKeys()
{
    $Key = file_get_contents('https://bt.1faryad.tech/api/wireguard/key_generate');
    $Key = json_decode($Key);
    $private_key = $Key->private_key;
    $public_key = $Key->public_key;

    return $Key = [
        'pr' => $private_key,
        'pu' => $public_key
    ];
}

function GetKeysInterfaceWireguard($panel_id, $interface)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $API->write("/interface/wireguard/print", false);
        $API->write("?name=" . $interface);
        $res = $API->read();
        $private_key = $res[0]['private-key'];
        $public_key = $res[0]['public-key'];
        return $Key = [
            'pr' => $private_key,
            'pu' => $public_key
        ];

    }
    return 0;
}


function CreateInterface($panel_id, $name, $ip, $port)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $API->comm('/interface/wireguard/add', array(
            'name' => $name,
            'listen-port' => $port,
            'comment' => $name,
        ));
        $API->comm('/ip/address/add', array(
            'interface' => $name,
            'address' => $ip . '.1/24',
        ));

        $panel_mangle = GetMangle($panel_id);
        $firewall = array(
            'chain' => 'prerouting',
            'in-interface' => $name,
            'action' => 'mark-routing',
            'new-routing-mark' => $panel_mangle,
        );
        $API->comm('/ip/firewall/mangle/add', $firewall);
        $API->write("/interface/wireguard/print", false);
        $API->write("=count-only", false);
        $API->write("?name=" . $name);
        $res = $API->read();
        if ($res == 0) {
            return 0;
        }
        return 1;
    } else {
        return "Not_Connect";
    }
    return 0;
}

function getVolome($peer_id)
{
    global $API;
    $peer_data = getPeerById($peer_id);
    $protocol = $peer_data['typeconfig'];
    $panel_id = $peer_data['panel_id'];
    $name = $peer_data['name'];
    $wire_id = $peer_data['wire_id'];
    if ($protocol == "wireguard") {
        $address = $peer_data['address'];
        if (connectMikrotik($panel_id)) {
            $API->write("/queue/simple/print", false);
            $API->write("?target=$address");
            $res = $API->read();
            if (count($res) > 0) {
                $res = $res[0]['bytes'];
                $array_bytes = explode('/', $res);
                if (count($array_bytes) == 2) {
                    $Bytes = $array_bytes[0] + $array_bytes[1];
                    return $Bytes;
                }
            } else
                return "notfound";
        } else
            return "notconnect";
    }
    if ($protocol == "ppp") {
        if (connectMikrotik($panel_id)) {
            if ($wire_id == 0) {
                $name = $peer_data['name'];
                $API->write("/user-manager/user/print", false);
                $API->write("?name=$name");
                $res = $API->read();
                $wire_id = $res[0]['.id'];
                SetWireIdById($peer_id, $wire_id);
            }
            if ($wire_id == 0) {
                return "not found id";
            }

            $number = array(
                "numbers" => $wire_id,
                "duration" => 1
            );
            $res = $API->comm("/user-manager/user/monitor", $number);
            if (count($res) > 0) {
                $download = $res[0]['total-download'];
                $upload = $res[0]['total-upload'];
                $Bytes = $download + $upload;
                return $Bytes;
            } else
                return "not found";
        } else
            return "notconnect";
    }
    if ($protocol == "v2ray") {
        if (connectV2ray_sanaei($panel_id)) {
            global $baseUrl;
            $Sanaei = new Sanaei($baseUrl);
            $res = $Sanaei->getClient($name);
            if (count($res) > 0) {
                $down = $res['obj']['down'];
                $up = $res['obj']['up'];
                $Bytes = $down + $up;
                return $Bytes;
            } else {
                return "not found";
            }
        } else
            return "notconnect";
    }
}

function wire_setstatus($panel_id, $id, $active)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $API->write('/interface/wireguard/peers/set', false);
        $API->write('=.id=' . $id, false);
        if ($active)
            $API->write('=disabled=false');
        else
            $API->write('=disabled=true');
        $API->read();
        return "ok";
    }
    return "not connect";
}

function ppp_setstatus($panel_id, $id, $active)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $API->write('/user-manager/user/set', false);
        $API->write('=.id=' . $id, false);
        if ($active)
            $API->write('=disabled=false');
        else
            $API->write('=disabled=true');
        $API->read();
        return "ok";
    }
    return "not connect";
}

function v2ray_setstatus($peer_id, $active)
{
    $peer_data = getPeerById($peer_id);
    $panel_id = $peer_data['panel_id'];
    $inbound_id = $peer_data['interface_id'];
    $email = $peer_data['name'];
    $uuid = $peer_data['wire_id'];
    $volome = $peer_data['limit_volome'];
    $inbound = getInbound($inbound_id)['inbound_id'];
    if (connectV2ray_sanaei($panel_id)) {
        global $baseUrl;
        $Sanaei = new Sanaei($baseUrl);
        $config = ["id" => $inbound, "settings" => json_encode(["clients" => [["id" => $uuid, 'flow' => '', 'email' => $email, 'limitIp' => '', 'totalGB' => $volome, 'expiryTime' => '', 'enable' => $active, 'tgId' => '', 'subId' => $email, 'reset' => 0]]])];
        $Res = $Sanaei->updateClient($uuid, $config);
        if ($Res["msg"] == "Client updated Successful" || $Res['success'] === true)
            return "ok";
        else
            return "no";
    }
    return "not connect";
}


function wire_resetvolom($panel_id, $address)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $API->write("/queue/simple/print", false);
        $API->write("?target=$address");
        $res = $API->read();
        $Id = $res[0]['.id'];
        $number = array('numbers' => $Id);
        $API->comm("/queue/simple/reset-counters", $number);
        return "ok";
    }
    return "not connect";
}

function ppp_resetvolom($panel_id, $Wire_id, $Username, $Password)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $number = array(
            "numbers" => $Wire_id
        );
        $API->comm("/user-manager/user/remove", $number);
        $API->comm('/user-manager/user/add',
            array(
                'name' => $Username,
                'password' => $Password,
                'shared-users' => 2,
            ));
        return "ok";
    }
    return "not connect";
}

function v2ray_resetvolom($peer_id)
{
    $peer_data = getPeerById($peer_id);
    $panel_id = $peer_data['panel_id'];
    $inbound_id = $peer_data['interface_id'];
    $email = $peer_data['name'];
    $inbound = getInbound($inbound_id)['inbound_id'];
    if (connectV2ray_sanaei($panel_id)) {
        global $baseUrl;
        $Sanaei = new Sanaei($baseUrl);
        $Res = $Sanaei->resetClientTraffic($inbound, $email);
        if ($Res['msg'] == "traffic reseted Successful" || $Res['success'] === true)
            return "ok";
        else
            return "no";
    }
    return "not connect";
}


function ppp_Delete($panel_id, $Wire_id)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $number = array(
            "numbers" => $Wire_id
        );
        $API->comm("/user-manager/user/remove", $number);
        return "ok";
    }
    return "not connect";
}

function wireguard_Delete($panel_id, $Wire_id)
{
    global $API;
    if (connectMikrotik($panel_id)) {
        $number = array(
            "numbers" => $Wire_id
        );
        $API->comm("/interface/wireguard/peers/remove", $number);
        return "ok";
    }
    return "not connect";
}


function v2ray_Delete($peer_id)
{
    $peer_data = getPeerById($peer_id);
    $panel_id = $peer_data['panel_id'];
    $inbound_id = $peer_data['interface_id'];
    $uuid = $peer_data['wire_id'];
    $inbound = getInbound($inbound_id)['inbound_id'];
    if (connectV2ray_sanaei($panel_id)) {
        global $baseUrl;
        $Sanaei = new Sanaei($baseUrl);
        $res = $Sanaei->deleteClient($inbound, $uuid);
        if ($res['success'] == 1)
            return "ok";
        else
            return "no";
    }
    return "not connect";
}

function getPanelIdByPeer($peer_id)
{
    global $connect;
    $tbl = $connect->query("SELECT `interface_id` FROM `peers` where `id` = '$peer_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $interface_id = $dt[0][0];
        $tbl = $connect->query("SELECT `panel_id` FROM `interfaces` WHERE `Id` = '$interface_id'");
        if ($tbl->num_rows > 0) {
            $dt = $tbl->fetch_all();
            $panel_id = $dt[0][0];
            return $panel_id;
        }
    }
    return 0;
}

function getPeerById($peer_id)
{
    global $connect;
    $tbl = $connect->query("SELECT `id`,`typeconfig`, `user_id`,`panel_id`,`interface_id`, `name`,`pass`, `address`, `.id`, `limit_volome`, `expire_day`, `expire_date`, `format`, `status`,`unshow_volome` FROM `peers` where `Id` = '$peer_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $id = $dt[0][0];
        $typeconfig = $dt[0][1];
        $user_id = $dt[0][2];
        $panel_id = $dt[0][3];
        $interface_id = $dt[0][4];
        $name = $dt[0][5];
        $pass = $dt[0][6];
        $address = $dt[0][7];
        $wire_id = $dt[0][8];
        $limit_volome = $dt[0][9];
        $expire_day = $dt[0][10];
        $expire_date = $dt[0][11];
        $format = $dt[0][12];
        $status = $dt[0][13];
        $unshow_volome = $dt[0][14];
        return [
            "id" => $id,
            "typeconfig" => $typeconfig,
            "user_id" => $user_id,
            "panel_id" => $panel_id,
            "interface_id" => $interface_id,
            "name" => $name,
            "pass" => $pass,
            "address" => $address,
            "wire_id" => $wire_id,
            "limit_volome" => $limit_volome,
            "expire_day" => $expire_day,
            "expire_date" => $expire_date,
            "format" => $format,
            "status" => $status,
            "unshow_volome" => $unshow_volome
        ];
    }
    return 0;
}

function CreateUserWireguard($user_id, $interface_id, $expire, $volome, $unshow_volom, $auto_expire_date)
{
    global $API;
    $interface_data = getInterface($interface_id);
    if ($interface_data == 0)
        return "invalid server id";
    $panel_id = $interface_data['panel_id'];
    $interface = $interface_data['interface'];
    $ip = $interface_data['ip'];
    $port = $interface_data['port'];
    $dns = $interface_data['dns'];
    $max_ip = $interface_data['max_ip'];
    $Address = $ip . '.' . $max_ip;
    $interface_fullname = $interface . "u" . $max_ip;
    $domain = getPanel($panel_id)['domain'];

    if ($max_ip == 255) {
        return "full_interface";
        exit();
    }
    if ($user_id == 0 || $user_id == null) {
        return 0;
        exit();
    }


    //--------------------
    $volome = $volome * (1024 * 1024 * 1024);
    $expire_day = $expire;
    if ($auto_expire_date === true)
        $expire_date = DateFormat(DateSumDay(DateHejri(), $expire_day));
    else
        $expire_date = "0";
    //--------------------

    if (connectMikrotik($panel_id)) {
        $API->write("/interface/wireguard/peers/print", false);
        $API->write("=count-only", false);
        $API->write("?allowed-address=$Address/32");
        $res = $API->read();
        if ($res > 0) {
            //SetMaxIp($interface_id);
            return "Error Find Address $Address/32 : Please try again later";
        }

        $peer_keys = GetKeys();
        $private_key_peer = $peer_keys['pr'];
        $public_key_peer = $peer_keys['pu'];

        $interface_keys = GetKeysInterfaceWireguard($panel_id, $interface);
        $privete_key_interface = $interface_keys['pr'];
        $Public_key_interface = $interface_keys['pu'];

        $peers = array(
            'interface' => $interface,
            'public-key' => $public_key_peer,
            'allowed-address' => $Address . '/32',
            'persistent-keepalive' => 25
        );
        $res = $API->comm('/interface/wireguard/peers/add', $peers);
        $res = json_encode($res);

        if (str_contains($res, "failure: entry already exists")) {
            $peer_keys = GetKeys();
            $private_key_peer = $peer_keys['pr'];
            $public_key_peer = $peer_keys['pu'];
            $peers = array(
                'interface' => $interface,
                'public-key' => $public_key_peer,
                'allowed-address' => $Address . '/32',
                'persistent-keepalive' => 25
            );
            $res = $API->comm('/interface/wireguard/peers/add', $peers);
        }
        $Public_key_interface = $Public_key_interface . '=';
        $txtFormat = "[Interface]
Address = $Address/24
PrivateKey = $private_key_peer
DNS = $dns
[Peer]
PublicKey = $Public_key_interface
AllowedIPs = 0.0.0.0/0
Endpoint = DOMAIN:$port
PersistentKeepalive = 25";
        $API->write("/interface/wireguard/peers/print", false);
        $API->write("=count-only", false);
        $API->write("?allowed-address=$Address/32");
        $res = $API->read();
        if ($res <= 0) {
            return "Error NotCreated User $Address/32";
        }
        $queue = array(
            'name' => $interface_fullname,
            'target' => $Address . '/32',
            'max-limit' => "500M/500M",
        );

        $res = $API->comm('/queue/simple/add', $queue);

        global $connect;
        SetMaxIp($interface_id);
        if (getUserVolome($user_id) > 0)
            alter_UserVolomeUse($user_id, $volome);
        $connect->query("INSERT INTO `peers`(`typeconfig`,`user_id`,`panel_id`,`interface_id`, `name`, `address`, `limit_volome`, `expire_day`, `expire_date`,`format`,`unshow_volome`) VALUES ('wireguard','$user_id','$panel_id','$interface_id','$interface_fullname','$Address/32','$volome','$expire_day','$expire_date','$txtFormat','$unshow_volom')");
        $peer_id = $connect->insert_id;
        //return SetFormatById($peer_id, $txtFormat);
        return $peer_id;
    }
    return "Not Connect to server";
}

function CreateUserPPP($user_id, $panel_id, $expire, $volome, $unshow_volom, $auto_expire_date)
{
    global $API;
    $panel_data = getPanel($panel_id);
    $Name = $panel_data['Name'];
    $row_id = $panel_data['row_id'];

    //-------------------
    $volome = $volome * (1024 * 1024 * 1024);
    $expire_day = $expire;
    if ($auto_expire_date === true)
        $expire_date = DateFormat(DateSumDay(DateHejri(), $expire_day));
    else
        $expire_date = "0";
    //-------------------

    if ($user_id == 0 || $user_id == null) {
        return 0;
        exit();
    }

    if ($expire <= 0) {
        echo "Service duration out of range";
        exit();
    }

    $Username = $Name  . "u" . $row_id;
    $Password = generate_password();
    if (connectMikrotik($panel_id)) {
        $API->write("/user-manager/user/print", false);
        $API->write("?name=$Username");
        $res = $API->read();
        if (count($res) > 0) {
            return "User Exist";
        }

        $API->comm('/user-manager/user/add',
            array(
                'name' => $Username,
                'password' => $Password,
                'shared-users' => 2,
            ));

        $API->write("/user-manager/user/print", false);
        $API->write("?name=$Username");
        $res = $API->read();
        if (count($res) == 1) {
            SetMaxRowPanel($panel_id);
            if (getUserVolome($user_id) > 0)
                alter_UserVolomeUse($user_id, $volome);
            global $connect;
            $connect->query("INSERT INTO `peers`(`typeconfig`,`user_id`,`panel_id`, `name`, `pass`, `limit_volome`, `expire_day`, `expire_date`,`unshow_volome`) VALUES ('ppp','$user_id','$panel_id','$Username','$Password','$volome','$expire_day','$expire_date','$unshow_volom')");
            $peer_id = $connect->insert_id;
            //return SetFormatById($peer_id, $txtFormat);
            return $peer_id;
        }
    }
    return "Not Connect to server";
}

function CreateUserV2ray($user_id, $inbound_id, $expire, $volome, $unshow_volom, $auto_expire_date)
{

    /*
'لطفا فرمت کد اتصال اینباند را ارسال نمایید :

پارامتر های ایجاد فرمت :

`$uuid` = شناسه کانفیگ
`$PanelLink` = دامنه پنل
`$PortInbound` = پورت اینباند
`$NameInbound` = نام اینباند
`$Email` = نام کانفیگ

مثال :
`vless://$uuid@$PanelLink:$PortInbound?type=tcp&security=tls&sni=$PanelLink#$NameInbound-$Email`'
     */
    global $API;
    global $connect;
    global $Sanaei;
    global $baseUrl;
    $inbound_data = getInbound($inbound_id);
    $panel_id = $inbound_data['panel_id'];
    $PanelLink = getPanel($panel_id)['Ip'];
    $inbound = $inbound_data['inbound_id'];
    $name = $inbound_data['name'];
    $port = $inbound_data['port'];
    $format = $inbound_data['format'];
    $max_id = $inbound_data['max_id'];
    $uuid = $max_id;
    if ($uuid == 0 || $uuid == null || $uuid == "") {
        exit();
    }

    if ($user_id == 0 || $user_id == null) {
        return 0;
        exit();
    }

    $email = "vi" . $inbound . 'u' . $max_id;
    //-------------------
    $volome = $volome * (1024 * 1024 * 1024);
    if (is_double($volome))
        $volome = round($volome);
    $expire_day = $expire;
    //$expire_day = (86400 * $expire_day) . "000";//((($Days*30)*86400)+time())*1000;
    //$expire_day = "-" . $expire_day;
    if ($auto_expire_date === true)
        $expire_date = DateFormat(DateSumDay(DateHejri(), $expire_day));
    else
        $expire_date = "0";
    //-------------------


    $format = str_replace('$uuid', $uuid, $format);
    $format = str_replace('$PanelLink', $PanelLink, $format);
    $format = str_replace('$PortInbound', $port, $format);
    $format = str_replace('$NameInbound', $name, $format);
    $format = str_replace('$Email', $email, $format);

    if (connectV2ray_sanaei($panel_id)) {
        $config = ["id" => $inbound, "settings" => json_encode(["clients" => [["id" => $uuid, 'flow' => '', 'email' => $email, 'limitIp' => '', 'totalGB' => $volome, 'expiryTime' => '', 'enable' => true, 'tgId' => '', 'subId' => $email, 'reset' => 0]]])];
        $Sanaei = new Sanaei($baseUrl);
        $Res = $Sanaei->addClient($config);
        $Res = $Res['success'];
        if ($Res == 1) {
            SetMaxRowInbound($inbound_id);
            if (getUserVolome($user_id) > 0)
                alter_UserVolomeUse($user_id, $volome);
            global $connect;
            $connect->query("INSERT INTO `peers`(`typeconfig`,`user_id`,`panel_id`,`interface_id`, `name`,`.id`, `limit_volome`, `expire_day`, `expire_date`,`format`,`unshow_volome`) VALUES ('v2ray','$user_id','$panel_id','$inbound_id','$email','$uuid','$volome','$expire','$expire_date','$format','$unshow_volom')");
            $peer_id = $connect->insert_id;
            //return SetFormatById($peer_id, $txtFormat);
            return $peer_id;
        } else {
            if (count($Sanaei->getClient($email)) > 0) {
                SetMaxRowInbound($inbound_id);
            }
            return "Please try again later";
        }
    } else
        return "Not Connect to server";
}

function get_type_server($panel_id)
{
    global $connect;
    $tbl = $connect->query("select `type_server` from `panels` where `Id` = '$panel_id'");
    if ($tbl->num_rows > 0) {
        $dt = $tbl->fetch_all();
        $type_server = $dt[0][0];
        return $type_server;
    }
    return 0;
}


function CheckConnect($panel_id)
{
    $type_server = get_type_server($panel_id);
    if ($type_server == type_server::mikrotik) {
        if (connectMikrotik($panel_id) == 1) {
            return 1;
        }
        return "not connect mikrotik";
    } elseif ($type_server == type_server::v2ray) {
        if (connectV2ray_sanaei($panel_id) == 1) {
            return 1;
        }
        return "not connect v2ray";
    }
    return 0;
}