<?php
# In the name of God
class Sanaei
{

    //private $baseUrl = '127.0.0.1:54321';
    private $baseUrl = 'vir.pergas.top:2023';

    public function __construct($baseUrl)
    {
        $this->baseUrl = $baseUrl;
    }

    /*
        Login Portal
    */

    public function login(array $content)
    {
        return $this->endpoint('login', 'POST', $content);
    }

    /*
        Get List Service
    */

    public function getList()
    {
        return $this->endpoint('panel/api/inbounds/list', 'GET', []);
    }

    /*
        Add Inbound 
    */

    public function addInbound(array $content)
    {
        return $this->endpoint('panel/api/inbounds/add', 'POST', $content);
    }

    /*
        Delete  Inbound 
    */

    public function deleteInbound($InboundID)
    {
        return $this->endpoint('panel/api/inbounds/del/:' . $InboundID, 'POST', []);
    }

    /*
        Update  Inbound 
    */

    public function updateInbound($InboundID, array $content)
    {
        return $this->endpoint('panel/api/inbounds/update/:' . $InboundID, 'POST', $content);
    }

    /*
        Add Client to inbound
    */

    public function addClient(array $content)
    {
        return $this->endpoint('panel/api/inbounds/addClient', 'POST', $content);
    }

    /*
        Get Client By Email
    */

    public function getClient($clientEmail)
    {
        return $this->endpoint('panel/api/inbounds/getClientTraffics/' . $clientEmail, 'GET', []);
    }

    /*
        Get Client IP By Email
    */

    public function getClientIP($clientEmail)
    {
        return $this->endpoint('panel/api/inbounds/clientIps/' . $clientEmail, 'POST', []);
    }

    /*
        Update Client by clientID
    */

    public function updateClient($clientID, array $content)
    {
        return $this->endpoint('panel/api/inbounds/updateClient/' . $clientID, 'POST', $content);
    }

    /*
        Delete Client by clientID
    */

    public function deleteClient($InboundID, $clientID)
    {
        return $this->endpoint('panel/api/inbounds/' . $InboundID . '/delClient/' . $clientID, 'POST', []);
    }

    /*
        reset Client Traffic
    */

    public function resetClientTraffic($InboundID, $clientEmail)
    {
        return $this->endpoint('panel/api/inbounds/' . $InboundID . '/resetClientTraffic/' . $clientEmail, 'POST', []);
    }

    /*
        Details Client
    */

    public function DetailsClient($InboundID, $clientID)
    {
        return $this->endpoint('panel/api/inbounds/' . $InboundID . '/information/' . $clientID, 'POST', []);
    }

    /*
        Status Restart
    */

    public function StatusRestart()
    {
        return $this->endpoint('server/restartXrayService', 'POST', []);
    }

    public function GetBackup()
    {
        return "http://" . $this->baseUrl . "/server/getDb";
    }


    /*
        Execute urls and send requests
    */

    public function endpoint($action, $method, array $content)
    {
        global $ssl;
        if ($ssl == true)
            $url_ssl = 'https';
        else
            $url_ssl = 'http';

        $get = curl_init();
        curl_setopt_array($get, array(
            CURLOPT_URL => $url_ssl . '://' . $this->baseUrl . '/' . $action,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => http_build_query($content),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING => '',
            CURLOPT_TIMEOUT => 30,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_COOKIEFILE => 'Cookie/' . $this->baseUrl . '.txt',
            CURLOPT_COOKIEJAR => 'Cookie/' . $this->baseUrl . '.txt',
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json, text/plain, */*',
                'Accept-Encoding: gzip, deflate',
                'Accept-Language: en-US,en;q=0.9,fa-IR;q=0.8,fa;q=0.7',
                'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/106.0.0.0 Safari/537.36',
                'X-Requested-With: XMLHttpRequest'
            )
        ));
        file_put_contents("sanaie.txt", curl_errno($get));
        $response = json_decode(curl_exec($get), true);

        if ($response === false or curl_errno($get)) {
            $response = ['success' => false, 'msg' => curl_error($get)];
        }
        curl_close($get);

        return $response;
    }
}