<?php
# In the name of God

class Marzban
{

    private $baseUrl = 'http://46.29.238.95:8000';

    private $ContentType =  'application/json';

    public function __construct($baseUrl)
    {
        $this->baseUrl = $baseUrl;
    }

    /*
        Login Panel
        @param array $content The login content, either in JSON format or URL-encoded form.
        @return array The login response containing the access token and other relevant information.
    */
    
    public function login($content)
    {
        $this->ContentType = 'application/x-www-form-urlencoded';

        $login = $this->endpoint('admin/token','POST' , $content);

        if($login['access_token'] != null)
        {
            file_put_contents('Coockie/'.$this->baseUrl . '.txt',$login['token_type'] . ' ' . $login['access_token']);
            return 1;
        }

        return $login;
    }

    /*
        Get Status Server
        @return array The server status response.
    */

    public function getStatus()
    {
        return $this->endpoint('system','GET' , []);
    }
    
    /*
        Get All List Service
        @return array The list of all users.
    */

    public function getAllUser()
    {
        return $this->endpoint('users', 'GET' , []);
    }

    /*
        Get Single User
        @param string $username The username of the user to retrieve.
        @return array The details of the specified user.
    */

    public function getUser($username)
    {
        return $this->endpoint('user/'.$username, 'GET' , []);
    }

    /*
        Add User Service
        @param array $content The content for adding a new user.
        @return array The response after adding a new user.
    */

    public function addUser($content)
    {
        return $this->endpoint('user','POST' , $content);
    }

    /*
        Delete User Service
        @param string $username The username of the user to be deleted.
        @return array The response after deleting the specified user.
    */

    public function deleteUser($username)
    {
        return $this->endpoint('user/'.$username,'DELETE' , []);
    }

    /*
        Edit User Service
        @param string $username The username of the user to be edited.
        @param array $content The new content for updating the user details.
        @return array The response after editing the specified user.
    */

    public function editUser($username , $content)
    {
        return $this->endpoint('user/'.$username,'PUT' , $content);
    }
    /*
        Execute urls and send requests
        @param string $action The API endpoint action.
        @param string $method The HTTP method (GET, POST, PUT, DELETE).
        @param array $content The content to be sent in the request body.
        @return array The response from the API.
    */




    private function endpoint($action , $method , $content ) 
    {
        global $ssl;
        if ($ssl == true)
            $url_ssl = 'https';
        else
            $url_ssl = 'http';

        $get = curl_init($url_ssl.'://' . $this->baseUrl . '/api/' .$action);

        curl_setopt_array($get, array(
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $content,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_COOKIEFILE => 'Cookie/' . $this->baseUrl . '.txt',
            CURLOPT_COOKIEJAR => 'Cookie/' . $this->baseUrl . '.txt',
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Content-Type: ' . $this->ContentType,
                'Authorization: ' . file_get_contents('Coockie/'.$this->baseUrl . '.txt')
            )
        ));

        $response = json_decode(curl_exec($get),true);

        if ($response === false or curl_errno($get)) 
        {
            $response = ['success'=>false, 'msg' => curl_error($get)];
        }
        curl_close($get);

        return $response;
    }
}
?>
