<?php
include "jdf.php";
function TimeNow()
{
    date_default_timezone_set('Asia/Tehran');
    $Time = date("H:i");
    return $Time;
}


function DateHejri()
{
    date_default_timezone_set('Asia/Tehran');
    $DateM = date('Y-m-d');
    $tar = str_split($DateM);
    $Y = $tar[0] . $tar[1] . $tar[2] . $tar[3];
    $M = $tar[5] . $tar[6];
    $D = $tar[8] . $tar[9];
    $DateHejri = gregorian_to_jalali($Y, $M, $D, '/');
    return DateFormat($DateHejri);
}

function DateMiladi()
{
    date_default_timezone_set('Asia/Tehran');
    return date('d/m/Y');
}


function getDateTime()
{
    date_default_timezone_set('Asia/Tehran');
    $DateM = date('Y-m-d');
    $tar = str_split($DateM);
    $Y = $tar[0] . $tar[1] . $tar[2] . $tar[3];
    $M = $tar[5] . $tar[6];
    $D = $tar[8] . $tar[9];
    $DateHejri = gregorian_to_jalali($Y, $M, $D, '/');
    $Time = date("H:i");

    return DateFormat($DateHejri) . ' ' . $Time;
}

function DateSumMounth($Date, $Num_m)
{
    $Date = explode('/', $Date);
    $Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    for ($i = 0; $i < $Num_m; $i++) {
        $M++;
        if ($M > 12) {
            $Y++;
            $M = 1;
        }
    }
    return $Y . '/' . $M . '/' . $D;
}

function DateSumDay($Date, $Num_d)
{
    $Date = explode('/', $Date);
    $Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    if ($Num_d < 0)
        $for = $Num_d * -1;
    else
        $for = $Num_d;
    for ($i = 0; $i < $for; $i++) {
        if ($Num_d > 0)
            $D++;
        else
            $D--;
        if ($M <= 6) {
            if ($Num_d > 0) {
                if ($D > 31) {
                    $M++;
                    if ($M > 12) {
                        $Y++;
                        $M = 1;
                    }
                    $D = 1;
                }
            } else {
                if ($D < 1) {
                    $M--;
                    if ($M < 1) {
                        $Y--;
                        $M = 12;
                    }
                    if ($M == 12)
                        $D = 29;
                    else
                        $D = 31;
                }
            }
        } else if ($M > 6) {
            if ($Num_d > 0) {
                if ($D > 30) {
                    $M++;
                    if ($M > 12) {
                        $Y++;
                        $M = 1;
                    }
                    $D = 1;
                }
            } else {
                if ($D < 1) {
                    $M--;
                    if ($M == 12)
                        $D = 29;
                    else
                        $D = 30;
                }
            }
        }
    }
    return $Y . '/' . $M . '/' . $D;
}

function DateFormat($Date)
{
    $Date = explode('/', $Date);
    $Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    if (strlen($M) < 2) {
        $M = "0" . $M;
    }
    if (strlen($D) < 2) {
        $D = "0" . $D;
    }
    return $Y . '/' . $M . '/' . $D;
}

function DateFormatMiladi($Date)
{
    return str_replace('/', '-', $Date);
    /*$Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    if (strlen($M) < 2){
        $M = "0".$M;
    }
    if (strlen($D) < 2){
        $D = "0".$D;
    }
    return $Y . '/' . $M . '/' . $D;*/
}


function GetDaysBetweenDate($Date1, $Date2)
{
    list($fdY, $fdM, $fdD) = explode('/', $Date1);
    list($sdY, $sdM, $sdD) = explode('/', $Date2);
    $fts = jmktime(0, 0, 0, $fdM, $fdD, $fdY);
    $sts = jmktime(0, 0, 0, $sdM, $sdD, $sdY);
    $diff = $sts - $fts;
    return round($diff / 86400);
}


function DateBeforMounth($Date)
{
    $Date = explode('/', $Date);
    $Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    $M--;
    if ($M <= 0) {
        $Y--;
        $M = 12;
    }
    return $Y . '/' . $M . '/' . $D;
}

function DateBeforDay($Date)
{
    $Date = explode('/', $Date);
    $Y = $Date[0];
    $M = $Date[1];
    $D = $Date[2];
    $D--;
    if ($D <= 0) {
        $M--;
        $D = 30;
    }
    return $Y . '/' . $M . '/' . $D;
}

function ConvertDateHejriToMiladi($DateHejri)
{
    date_default_timezone_set('Asia/Tehran');
    $tar = str_split($DateHejri);
    $Y = $tar[0] . $tar[1] . $tar[2] . $tar[3];
    $M = $tar[5] . $tar[6];
    $D = $tar[8] . $tar[9];
    $DateMiladi = jalali_to_gregorian($Y, $M, $D, '/');
    return $DateMiladi;
}

function ConvertDateMiladiToTimeStamp($DateMiladi)
{
    $Date = new DateTime($DateMiladi);
    return $Date->getTimestamp();
}

function ConvertTimeToTimeStamp($Time)
{
    $Times = strtotime($Time);
    return $Times;
}

