<?php

require "Router/Router.php";
include "config/db.php";
include "DateTime/DateTime.php";
$router = new Router();


function encode($value)
{
    $enc = zlib_encode($value, ZLIB_ENCODING_DEFLATE);

    $CodePagiri = base64_encode($enc);
    return $CodePagiri;
}

function decode($value)
{
    $enc = base64_decode($value);

    $CodePagiri = zlib_decode($enc, ZLIB_ENCODING_DEFLATE);

    return $CodePagiri;
}

//-------------------------------------------------------------------------------------------------------------------------------------------
$router->route("/request", function ($action, $data = "") {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        global $connect;
        if (isset($_SERVER['HTTP_API_TOKEN'])) {
            try {
                $API_TOKEN = $_SERVER['HTTP_API_TOKEN'];
                $API_TOKEN_DATE = explode(':', $API_TOKEN)[0];
                $API_TOKEN_DATA = decode(explode(':', $API_TOKEN)[1]);
                $API_TOKEN_DECODE = explode(':', $API_TOKEN_DATA);
                $company = $API_TOKEN_DECODE[0];
                if ($company != "version")
                    exit();
                $user_id = $API_TOKEN_DECODE[1];
            } catch (Exception $exception) {
                echo json_encode(["success" => false, "result" => ["msg" => "bad request"]]);
                exit();
            }
            $tbl_user = $connect->query("select `fullname`, `username`, `password`,`api_token`, `expire_date`, `volome`, `volome_use`, `status` from `users` where `id` = '$user_id'");
            if ($tbl_user->num_rows > 0) {
                $dt = $tbl_user->fetch_all();
                $fullname = $dt[0][0];
                $username = $dt[0][1];
                $password = $dt[0][2];
                $api_token = $dt[0][3];
                if ($api_token != $API_TOKEN) {
                    echo json_encode(["success" => true, "result" => ["access" => "expired token"]]);
                    exit();
                }
                $expire_date = $dt[0][4];
                $volome = $dt[0][5];
                $volome_use = $dt[0][6];
                $status = $dt[0][7];
                if ($status == 0) {
                    echo json_encode(["success" => true, "result" => ["access" => "block"]]);
                    exit();
                }
                if ($expire_date < DateHejri()) {
                    echo json_encode(["success" => true, "result" => ["access" => "expired"]]);
                    exit();
                }
                if ($volome_use > $volome && $volome > 0) {
                    echo json_encode(["success" => true, "result" => ["access" => "full volome"]]);
                    exit();
                }
            }
            if ($action == "CreateUser") {
                // data
                $protocol = $_POST["protocol"];
                $expire = $_POST["expire"];
                $volome = $_POST["volome"];
                $unshow_volom = $_POST["unshow_volome"];
                if (isset($_POST["auto_expire_date"]))
                    $auto_expire_date = $_POST["auto_expire_date"];
                else
                    $auto_expire_date = 0;
                $server_id = $_POST["server_id"];


                // request
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://$_SERVER[HTTP_HOST]/Main/api/api.php",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array(
                        "request" => $action,
                        "user_id" => $user_id,
                        "protocol" => $protocol,
                        "expire" => $expire,
                        "volome" => $volome,
                        "unshow_volome" => $unshow_volom,
                        "auto_expire_date" => $auto_expire_date,
                        "server_id" => $server_id,
                    ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);

                // response
                if (str_starts_with($response, "CreateUserSuccess:")) {
                    $response = explode(':', $response);
                    $peer_id = $response[1];
                    echo json_encode(["success" => true, "result" => ["request" => "CreateUser", "client_id" => $peer_id]]);
                    exit();
                } else if (str_starts_with($response, "CreateUserError:")) {
                    $response = explode(':', $response);
                    $msg = $response[1];
                    if ($msg == "full_interface") {
                        echo json_encode(["success" => false, "result" => ["request" => "CreateUser", "msg" => "full server"]]);
                        exit();
                    } else if ($msg == "MaxVolome") {
                        echo json_encode(["success" => false, "result" => ["request" => "CreateUser", "msg" => "full volome"]]);
                        exit();
                    } else if ($msg == "Service duration out of range") {
                        echo json_encode(["success" => false, "result" => ["request" => "CreateUser", "msg" => "Service duration out of range"]]);
                        exit();
                    } else if ($msg == "Service volume out of range") {
                        echo json_encode(["success" => false, "result" => ["request" => "CreateUser", "msg" => "Service volume out of range"]]);
                        exit();
                    } else {
                        echo json_encode(["success" => false, "result" => ["request" => "CreateUser", "msg" => $msg]]);
                        exit();
                    }
                }
                exit();
            } else if ($action == "GetClient") {
                $peer_id = decode($data);
                $tbl = $connect->query("SELECT `typeconfig`, `panel_id`,`interface_id`, `name`, `pass`,  `limit_volome`, `expire_day`, `expire_date`, `format`, `status` FROM `peers` WHERE `id` = '$peer_id'");
                if ($tbl->num_rows > 0) {
                    $volome_use = file_get_contents("https://$_SERVER[HTTP_HOST]/Main/api/api.php?request=get_volom&peer_id=" . $peer_id);
                    $dt = $tbl->fetch_all();
                    $protocol = $dt[0][0];
                    $panel_id = $dt[0][1];
                    $interface_id = $dt[0][2];
                    $name = $dt[0][3];
                    $pass = $dt[0][4];
                    $limit_volome = $dt[0][5] / (1024 * 1024);
                    $expire_day = $dt[0][6];
                    $expire_date = $dt[0][7];
                    $format = $dt[0][8];
                    $status = $dt[0][9];
                    if ($status == 0) {
                        $status = "enable";
                    } else if ($status == 1) {
                        $status = "end of time";
                    } else if ($status == 2) {
                        $status = "end of traffic";
                    } else if ($status == 3) {
                        $status = "disabled";
                    }
                    if ($expire_date == 0) {
                        $expire_date = "Start After First Use";
                    }

                    if ($protocol == "wireguard")
                        $connection = array(
                            "file_name" => $name . ".conf",
                            "data" => $format,
                            "traffic_use" => $volome_use
                        );
                    else if ($protocol == "ppp")
                        $connection = array(
                            "username" => $name,
                            "password" => $pass,
                            "traffic_use" => $volome_use
                        );
                    else if ($protocol == "v2ray")
                        $connection = array(
                            "email" => $name,
                            "data" => $format,
                            "traffic_use" => $volome_use
                        );

                    echo json_encode(
                        ["success" => true,
                            "result" => [
                                "request" => "GetClient",
                                "protocol" => $protocol,
                                "information" => [
                                    "expire_date" => $expire_date,
                                    "all_days" => $expire_day,
                                    "traffic" => $limit_volome,
                                    "status" => $status
                                ],
                                "connection" => $connection
                            ]]);
                    exit();

                } else {
                    echo json_encode(["success" => false, "result" => ["request" => "GetClient", "msg" => "invalid client"]]);
                    exit();
                }
            } else if ($action == "dateRenewel") {

                // data
                $peer_id = decode($data);
                // request
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://$_SERVER[HTTP_HOST]/Main/api/api.php",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array(
                        "request" => "resetDate_config",
                        "peer_id" => $peer_id,
                    ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);

                if ($response == "reset_date") {
                    echo json_encode(["success" => true, "result" => ["request" => "dateRenewel", "msg" => "Client DateRenewel Success"]]);
                    exit();
                } else if (str_starts_with($response, "not expired")) {
                    echo json_encode(["success" => false, "result" => ["request" => "dateRenewel", "msg" => "not expired"]]);
                    exit();
                } else {
                    echo json_encode(["success" => false, "result" => ["request" => "dateRenewel", "msg" => "$response"]]);
                    exit();
                }
                //not expired

            } else if ($action == "resetTraffic") {
                // data
                $peer_id = decode($data);
                // request
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://$_SERVER[HTTP_HOST]/Main/api/api.php",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array(
                        "request" => "resetVolome_config",
                        "peer_id" => $peer_id,
                    ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);

                if ($response == "reset_volome") {
                    echo json_encode(["success" => true, "result" => ["request" => "resetTraffic", "msg" => "Client resetTraffic Success"]]);
                    exit();
                } else if (str_starts_with($response, "MaxVolome")) {
                    echo json_encode(["success" => false, "result" => ["request" => "resetTraffic", "msg" => "Max Volome Panel"]]);
                    exit();
                } else {
                    echo json_encode(["success" => false, "result" => ["request" => "resetTraffic", "msg" => "$response"]]);
                    exit();
                }
            }
        }
    }

    echo json_encode(["success" => false, "result" => ["msg" => "bad request"]]);
    exit();
    //die(isset($_SERVER['REQUEST_METHOD']) ? "type : " . $_SERVER['REQUEST_METHOD'] : "not found");
});

$router->route("/Main/info", function ($peer_id) {
    echo file_get_contents("https://" . $_SERVER['HTTP_HOST'] . "/Main/info/peer.php?pid=$peer_id");
});

$router->execute();

